/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIBreeEat;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.ai.LOTREntityAIHobbitSmoke;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityRuffianBrute;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.IPickpocketable;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenBreeland;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityBreeMan
extends LOTREntityMan
implements IPickpocketable {
    public static final String CARROT_EATER_NAME = "Peter Jackson";
    private static ItemStack[] weapons = new ItemStack[]{new ItemStack(LOTRMod.daggerIron), new ItemStack(LOTRMod.daggerBronze), new ItemStack(Items.field_151036_c), new ItemStack(LOTRMod.axeBronze), new ItemStack(Items.field_151049_t)};

    public LOTREntityBreeMan(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(1, this.createBreeAttackAI());
        int p = this.addBreeAttackAI(2);
        this.addBreeHiringAI(p + 1);
        this.field_70714_bg.func_75776_a(p + 2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.addBreeAvoidAI(p + 3);
        this.field_70714_bg.func_75776_a(p + 4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(p + 5, (EntityAIBase)new LOTREntityAIBreeEat(this, LOTRFoods.BREE, 8000));
        this.field_70714_bg.func_75776_a(p + 5, (EntityAIBase)new LOTREntityAIDrink(this, LOTRFoods.BREE_DRINK, 8000));
        this.field_70714_bg.func_75776_a(p + 5, (EntityAIBase)new LOTREntityAIHobbitSmoke(this, 12000));
        this.field_70714_bg.func_75776_a(p + 6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(p + 6, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(p + 7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(p + 8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(false);
    }

    protected EntityAIBase createBreeAttackAI() {
        return new EntityAIPanic((EntityCreature)this, 1.7);
    }

    protected int addBreeAttackAI(int prio) {
        this.field_70714_bg.func_75776_a(prio, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.3, false));
        return prio;
    }

    protected void addBreeHiringAI(int prio) {
        this.field_70714_bg.func_75776_a(prio, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
    }

    protected void addBreeAvoidAI(int prio) {
        this.field_70714_bg.func_75776_a(prio, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, LOTREntityRuffianBrute.class, 8.0f, 1.0, 1.5));
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(this.field_70146_Z.nextBoolean());
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getBreeName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(weapons.length);
        this.npcItemsInv.setMeleeWeapon(weapons[i].func_77946_l());
        this.npcItemsInv.setIdleItem(null);
        if (this.familyInfo.isMale() && this.field_70146_Z.nextInt(2000) == 0) {
            this.familyInfo.setName(CARROT_EATER_NAME);
            this.npcItemsInv.setIdleItem(new ItemStack(Items.field_151172_bF));
        }
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.BREE;
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        this.dropBreeItems(flag, i);
    }

    protected void dropBreeItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.dropChestContents(LOTRChestContents.BREE_HOUSE, 1, 2 + i);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killBreelander;
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if (j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A) {
                return true;
            }
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenBreeland) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendly(entityplayer)) {
            return "bree/man/friendly";
        }
        return "bree/man/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.BREE.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.BREE;
    }

    @Override
    public boolean canPickpocket() {
        return true;
    }

    @Override
    public ItemStack createPickpocketItem() {
        return LOTRChestContents.BREE_PICKPOCKET.getOneItem(this.field_70146_Z, true);
    }
}

